/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.mail.storage.implementations;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import net.impactdev.impactor.api.mail.MailMessage;
import net.impactdev.impactor.api.mail.filters.MailFilter;
import net.impactdev.impactor.api.storage.connection.configurate.ConfigurateLoader;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.api.utility.printing.PrettyPrinter;
import net.impactdev.impactor.core.mail.ImpactorMailMessage;
import net.impactdev.impactor.core.mail.storage.MailStorageImplementation;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Caffeine;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.LoadingCache;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.ConfigurationNode;
import net.impactdev.impactor.relocations.org.spongepowered.configurate.loader.ConfigurationLoader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.util.TriState;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MailConfigurateProvider
implements MailStorageImplementation {
    private final ConfigurateLoader loader;
    private final Path root;
    private final LoadingCache<Path, ReentrantLock> ioLocks;

    public MailConfigurateProvider(@NotNull ConfigurateLoader loader) {
        this.loader = loader;
        this.root = Paths.get("config", new String[0]).resolve("impactor").resolve("mail").resolve("users");
        this.ioLocks = Caffeine.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> new ReentrantLock());
    }

    private void createDirectoriesIfNotExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return;
        }
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public String name() {
        return null;
    }

    @Override
    public void init() throws Exception {
        this.createDirectoriesIfNotExists(this.root);
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    public void meta(PrettyPrinter printer) throws Exception {
    }

    @Override
    public List<MailMessage> mail(UUID target) throws Exception {
        ArrayList inbox = Lists.newArrayList();
        Path branch = this.target(target);
        for (File file : Objects.requireNonNull(branch.toFile().listFiles())) {
            if (!file.isDirectory()) continue;
            for (File child : Objects.requireNonNull(file.listFiles())) {
                this.readMessage(child.toPath()).ifPresent(inbox::add);
            }
        }
        return inbox;
    }

    @Override
    public boolean append(UUID target, MailMessage message) throws Exception {
        String uuid = message.uuid().toString();
        Path branch = this.target(target).resolve(uuid.substring(0, 2));
        Files.createDirectories(branch, new FileAttribute[0]);
        this.writeMessage(branch.resolve(uuid + ".json"), message);
        return true;
    }

    @Override
    public TriState delete(UUID target, MailMessage message) throws Exception {
        String uuid = message.uuid().toString();
        File root = this.target(target).toFile();
        if (root.isDirectory() && root.list() == null) {
            return TriState.NOT_SET;
        }
        Path leaf = root.toPath().resolve(uuid.substring(0, 2)).resolve(uuid + ".json");
        if (Files.exists(leaf, new LinkOption[0])) {
            this.writeMessage(leaf, null);
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Override
    public TriState deleteWhere(@NotNull UUID target, @Nullable MailFilter filter) throws Exception {
        Path root = this.target(target);
        if (filter == null && Files.exists(root, new LinkOption[0])) {
            FileUtils.deleteDirectory((File)root.toFile());
            return TriState.TRUE;
        }
        if (filter == null) {
            return TriState.NOT_SET;
        }
        boolean failed = false;
        Stream<MailMessage> mail = this.mail(target).stream().filter(filter);
        for (MailMessage message : mail.toList()) {
            TriState result = this.delete(target, message);
            if (result == TriState.NOT_SET) {
                throw new IllegalStateException("Inbox empty despite recent successful mail fetch");
            }
            if (failed || result != TriState.FALSE) continue;
            failed = true;
        }
        return TriState.byBoolean((!failed ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<MailMessage> readMessage(Path path) {
        if (path.toFile().exists()) {
            ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get(path));
            lock.lock();
            try {
                UUID uuid = UUID.fromString(path.getFileName().toString().replace(".json", ""));
                ConfigurationNode node = this.loader.loader(path).load();
                UUID source2 = node.node("source").get(UUID.class);
                Instant instant = node.node("timestamp").get(Instant.class);
                JsonElement json = Objects.requireNonNull(node.node("message").get(JsonElement.class));
                Component message = GsonComponentSerializer.gson().deserializeFromTree(json);
                Optional<MailMessage> optional = Optional.of(new ImpactorMailMessage(uuid, source2, message, instant));
                return optional;
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                Optional<MailMessage> optional = Optional.empty();
                return optional;
            }
            finally {
                lock.unlock();
            }
        }
        return Optional.empty();
    }

    private void writeMessage(Path target, @Nullable MailMessage message) {
        ReentrantLock lock = Objects.requireNonNull(this.ioLocks.get(target));
        lock.lock();
        try {
            if (message == null) {
                Files.deleteIfExists(target);
            } else {
                JsonElement json = GsonComponentSerializer.gson().serializeToTree(message.content());
                ConfigurationLoader<? extends ConfigurationNode> loader = this.loader.loader(target);
                Object node = loader.createNode();
                if (message.source().isPresent()) {
                    node.node("source").set(UUID.class, message.source().get());
                }
                node.node("timestamp").set(Instant.class, message.timestamp());
                node.node("message").set(JsonElement.class, json);
                loader.save((ConfigurationNode)node);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private Path target(UUID target) throws Exception {
        String id = target.toString();
        Path path = this.root.resolve(id.substring(0, 2)).resolve(id);
        this.createDirectoriesIfNotExists(path);
        return path;
    }
}

